/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.global;

import com.siemens.mp.global.MemoryInputStream;
import com.siemens.mp.global.ResourceException;
import com.siemens.mp.global.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public final class ResourceManager {
    private String baseName;
    private String locale;
    private InputStream resourceStream;
    private boolean isHierarchical;
    private boolean onlyNativeResources;
    private ResourceManager parent;
    private byte[][] header;
    private static final int ID_BORDER = 0xFFFFFFF;
    private static final int STRING_RSRC = 0;
    private static final int IMAGE_RSRC = 1;
    private static final char PATH_SEPARATOR = '/';
    private static final String GLOBAL_DIRECTORY = "global";
    private static final String FILE_EXTENSION = ".res";
    private int[] pointerLru;
    private static final int EOF = 0;
    private static final int STRING = 1;
    private static final int IMAGE = 16;
    private byte[] imageArray;
    private String stringResource;
    private Object nativeObject;
    private static String[] instanceSupportedLocales;
    private static String[] supportedLocales;
    private static final byte[] SIGNATURE;
    private static final Hashtable INSTANCES;
    static /* synthetic */ Class class$0;

    static {
        supportedLocales = new String[]{"ar", "bg", "ca", "cs", "da", "de", "el", "en_US", "en_GB", "en_TW", "es", "es_MX", "et", "fa", "fi", "fr", "fr_CA", "he", "hi", "hr", "hu", "id", "it", "lt", "lv", "ml", "ms", "nl", "no", "pl", "pt_PT", "pt_BR", "ro", "ru", "sk", "sl", "sr", "sv", "th", "tl", "tr", "uk", "ur", "vi", "zh", "zh_TW"};
        SIGNATURE = new byte[4];
        ResourceManager.SIGNATURE[0] = -18;
        ResourceManager.SIGNATURE[1] = 77;
        ResourceManager.SIGNATURE[2] = 73;
        ResourceManager.SIGNATURE[3] = 1;
        INSTANCES = new Hashtable();
    }

    private ResourceManager(String locale, String baseName, InputStream resourceStream, boolean isHierarchical) {
        int[] nArray = new int[5];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 1;
        this.pointerLru = nArray;
        this.locale = locale;
        this.baseName = baseName;
        this.resourceStream = resourceStream;
        this.isHierarchical = isHierarchical;
        boolean bl = this.onlyNativeResources = resourceStream == null;
        if (!this.onlyNativeResources) {
            try {
                int headerSize = resourceStream.read() << 24 | resourceStream.read() << 16 | resourceStream.read() << 8 | resourceStream.read();
                this.header = new byte[headerSize / 4][4];
                int i = 0;
                while (i < this.header.length) {
                    resourceStream.read(this.header[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                throw new ResourceException(0, "Internal Error");
            }
            INSTANCES.put(String.valueOf(locale) + baseName, this);
        }
    }

    public static ResourceManager getManager(String baseName) {
        String locale = System.getProperty("microedition.locale");
        if (locale == null) {
            throw new ResourceException(8, "the default locale must not be null");
        }
        return ResourceManager.getManager(baseName, locale);
    }

    public static ResourceManager getManager(String baseName, String locale) {
        boolean onlyNativeResources;
        boolean bl = onlyNativeResources = baseName == null;
        if (!onlyNativeResources && baseName.trim().equals("")) {
            throw new IllegalArgumentException("The base name must not be empty");
        }
        if (locale == null) {
            throw new IllegalArgumentException("The specified locale must not be null");
        }
        ResourceManager instance = (ResourceManager)INSTANCES.get(String.valueOf(locale) + baseName);
        if (instance != null) {
            return instance;
        }
        MemoryInputStream resourceStream = null;
        boolean hasParent = true;
        locale = Util.getValidLocale(locale, false);
        if (!onlyNativeResources) {
            StringBuffer resourcePath;
            if (!locale.trim().equals("")) {
                Class<?> clazz;
                int localeSeparatorPosition = locale.length();
                do {
                    locale = locale.substring(0, localeSeparatorPosition);
                    resourcePath = new StringBuffer("/global/").append(locale).append('/').append(baseName).append(FILE_EXTENSION);
                    clazz = class$0;
                    if (clazz != null) continue;
                    try {
                        clazz = Class.forName("com.siemens.mp.global.ResourceManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                } while (((resourceStream = new MemoryInputStream(clazz.getResourceAsStream(resourcePath.toString()))) == null || !ResourceManager.isFileValid(resourceStream)) && (localeSeparatorPosition = locale.lastIndexOf(45)) != -1);
            }
            if (resourceStream == null || !ResourceManager.isFileValid(resourceStream)) {
                resourcePath = new StringBuffer("/global/").append(baseName).append(FILE_EXTENSION);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.siemens.mp.global.ResourceManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((resourceStream = new MemoryInputStream(clazz.getResourceAsStream(resourcePath.toString()))) == null || !ResourceManager.isFileValid(resourceStream)) {
                    throw new ResourceException(4, "no resources for this base name found");
                }
                hasParent = false;
                locale = "";
            }
        } else {
            boolean isSupported = false;
            int i = 0;
            while (i < supportedLocales.length) {
                if (supportedLocales[i].trim().compareTo(locale) == 0) {
                    isSupported = true;
                    break;
                }
                ++i;
            }
            if (!isSupported) {
                throw new ResourceException(4, "no resources for this base name found");
            }
        }
        return new ResourceManager(locale, baseName, resourceStream, hasParent);
    }

    public static ResourceManager getManager(String baseName, String[] locales) {
        boolean onlyNativeResources;
        boolean bl = onlyNativeResources = baseName == null;
        if (!onlyNativeResources && baseName.trim().equals("")) {
            throw new IllegalArgumentException("The base name must not be empty");
        }
        if (locales == null) {
            throw new IllegalArgumentException("the locales array must not be null");
        }
        ResourceManager instance = null;
        int i = locales.length - 1;
        while (i >= 0) {
            if (locales[i] == null) {
                throw new IllegalArgumentException("Any of the locales in the array must not be null");
            }
            locales[i] = Util.getValidLocale(locales[i], false);
            instance = !onlyNativeResources && instance == null ? (ResourceManager)INSTANCES.get(String.valueOf(locales[i]) + baseName) : instance;
            --i;
        }
        if (instance != null) {
            return instance;
        }
        String locale = null;
        MemoryInputStream resourceStream = null;
        if (!onlyNativeResources) {
            int i2 = 0;
            while (!(i2 >= locales.length || resourceStream != null && ResourceManager.isFileValid(resourceStream))) {
                locale = locales[i2];
                StringBuffer resourcePath = locale.trim().equals("") ? new StringBuffer("/global/").append(baseName).append(FILE_EXTENSION) : new StringBuffer("/global/").append(locale).append('/').append(baseName).append(FILE_EXTENSION);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("com.siemens.mp.global.ResourceManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resourceStream = new MemoryInputStream(clazz.getResourceAsStream(resourcePath.toString()));
                ++i2;
            }
            if (resourceStream == null || !ResourceManager.isFileValid(resourceStream)) {
                throw new ResourceException(4, "no resources for this base name found");
            }
        } else {
            boolean isSupported = false;
            int i3 = 0;
            while (i3 < supportedLocales.length) {
                if (supportedLocales[i3].trim().compareTo(locale) == 0) {
                    isSupported = true;
                    break;
                }
                ++i3;
            }
            if (!isSupported) {
                throw new ResourceException(4, "no resources for this base name found");
            }
        }
        return new ResourceManager(locale, baseName, resourceStream, false);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getLocale() {
        return this.locale;
    }

    public Object getResource(int id) {
        if (id <= 0xFFFFFFF) {
            if (this.onlyNativeResources) {
                throw new ResourceException(1, "Resource not found");
            }
            switch (this.header[id][0]) {
                case 16: {
                    return this.getImage(id);
                }
                case 1: {
                    return this.getString(id);
                }
                case 0: {
                    ResourceManager parent = this.getParent();
                    if (parent != null && this.isHierarchical) {
                        return parent.getResource(id);
                    }
                    throw new ResourceException(1, "Resource not found");
                }
            }
            throw new ResourceException(2, "wrong type of resource ID");
        }
        throw new RuntimeException("Resource native not implemented");
    }

    public String getString(int id) {
        if (id <= 0xFFFFFFF) {
            if (this.onlyNativeResources) {
                throw new ResourceException(1, "Resource not found");
            }
            if (id < 0 || id > this.header.length - 2) {
                if (this.isHierarchical) {
                    ResourceManager parent = this.getParent();
                    if (parent != null) {
                        return parent.getString(id);
                    }
                    throw new ResourceException(1, "Resource not found");
                }
                throw new ResourceException(1, "Resource not found");
            }
            if (this.header[id][0] == 0) {
                ResourceManager parent = this.getParent();
                if (parent != null) {
                    return parent.getString(id);
                }
                throw new ResourceException(1, "Resource not found");
            }
            if (this.header[id][0] != 1) {
                throw new ResourceException(5, "Not a string resource");
            }
            try {
                return new String(this.getContent(id), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException(0, "Internal Error");
            }
        }
        throw new RuntimeException("Resource native not implemented");
    }

    public Image getImage(int id) {
        if (id <= 0xFFFFFFF) {
            if (this.onlyNativeResources) {
                throw new ResourceException(1, "Resource not found");
            }
            if (id < 0 || id > this.header.length - 2) {
                if (this.isHierarchical) {
                    ResourceManager parent = this.getParent();
                    if (parent != null) {
                        return parent.getImage(id);
                    }
                    throw new ResourceException(1, "Resource not found");
                }
                throw new ResourceException(1, "Resource not found");
            }
            if (this.header[id][0] == 0) {
                ResourceManager parent = this.getParent();
                if (parent != null) {
                    return parent.getImage(id);
                }
                throw new ResourceException(1, "Resource not found");
            }
            if (this.header[id][0] != 16) {
                throw new ResourceException(6, "not an image resource");
            }
            try {
                return Image.createImage((String)new String(this.getContent(id), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException(0, "Internal Error");
            }
            catch (IOException e) {
                throw new ResourceException(0, "Internal Error");
            }
        }
        throw new RuntimeException("Resource native not implemented");
    }

    public boolean isValidResourceID(int id) {
        if (id <= 0xFFFFFFF) {
            if (this.onlyNativeResources) {
                return false;
            }
            if (id >= 0 && id < this.header.length) {
                return true;
            }
            if (this.isHierarchical) {
                ResourceManager parent = this.getParent();
                if (parent != null) {
                    return parent.isValidResourceID(id);
                }
                return false;
            }
            return false;
        }
        throw new RuntimeException("Resource native not implemented");
    }

    public String[] getSupportedLocales() {
        if (instanceSupportedLocales == null) {
            if (!this.onlyNativeResources) {
                if (this.isHierarchical) {
                    int localeSeparatorPosition;
                    int i;
                    InputStream stream;
                    String tmpLocale = this.locale;
                    String[] tmpLocales = new String[4];
                    StringBuffer resourcePath = new StringBuffer("/global/").append(this.baseName).append(FILE_EXTENSION);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("com.siemens.mp.global.ResourceManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((stream = new MemoryInputStream(clazz.getResourceAsStream(resourcePath.toString()))) != null && ResourceManager.isFileValid(stream)) {
                        tmpLocales[0] = "";
                        tmpLocales[1] = this.locale;
                        i = 2;
                    } else {
                        tmpLocales[0] = this.locale;
                        i = 1;
                    }
                    while ((localeSeparatorPosition = tmpLocale.lastIndexOf(45)) != -1) {
                        tmpLocale = tmpLocale.substring(0, localeSeparatorPosition);
                        resourcePath = new StringBuffer("/global/").append(tmpLocale).append('/').append(this.baseName).append(FILE_EXTENSION);
                        stream = this.getClass().getResourceAsStream(resourcePath.toString());
                        if (stream == null || !ResourceManager.isFileValid(stream)) continue;
                        if (i == tmpLocales.length) {
                            String[] tmp = new String[i];
                            System.arraycopy(tmpLocales, 0, tmp, 0, i);
                            tmpLocales = tmp;
                        }
                        tmpLocales[i] = tmpLocale;
                        ++i;
                    }
                    instanceSupportedLocales = new String[i];
                    System.arraycopy(tmpLocales, 0, instanceSupportedLocales, 0, i);
                } else {
                    instanceSupportedLocales = new String[]{this.locale};
                }
            } else {
                instanceSupportedLocales = supportedLocales;
            }
        }
        return instanceSupportedLocales;
    }

    public boolean isCaching() {
        return !this.onlyNativeResources;
    }

    private static boolean isFileValid(InputStream inputStream) {
        try {
            inputStream.reset();
            byte[] signature = new byte[SIGNATURE.length];
            inputStream.read(signature);
            int i = 0;
            while (i < signature.length) {
                if (signature[i] != SIGNATURE[i]) {
                    return false;
                }
                ++i;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private ResourceManager getParent() {
        if (this.parent == null) {
            try {
                int localeSeparatorPosition = this.locale.lastIndexOf(45);
                if (localeSeparatorPosition != -1) {
                    this.parent = ResourceManager.getManager(this.baseName, this.locale.substring(0, localeSeparatorPosition));
                } else if (!this.locale.trim().equals("")) {
                    this.parent = ResourceManager.getManager(this.baseName, "");
                }
            }
            catch (ResourceException e) {
                if (e.getErrorCode() == 4) {
                    this.parent = null;
                }
                throw e;
            }
        }
        return this.parent;
    }

    private byte[] getContent(int id) {
        try {
            int dataOffset = (this.header[id][1] & 0xFF) << 16 | (this.header[id][2] & 0xFF) << 8 | this.header[id][3] & 0xFF;
            int until = (this.header[id + 1][1] & 0xFF) << 16 | (this.header[id + 1][2] & 0xFF) << 8 | this.header[id + 1][3] & 0xFF;
            byte[] tmpData = this.readFile(dataOffset, new byte[until - dataOffset]);
            return tmpData;
        }
        catch (Exception e) {
            throw new ResourceException(0, "Internal Error");
        }
    }

    private synchronized byte[] readFile(int dataOffset, byte[] tmpData) throws IOException {
        this.resourceStream.reset();
        this.resourceStream.skip(dataOffset);
        this.resourceStream.read(tmpData);
        return tmpData;
    }

    private int moveFirst(int id) {
        int tmp = this.pointerLru[id];
        if (id == 0) {
            return tmp;
        }
        ResourceManager resourceManager = this;
        synchronized (resourceManager) {
            System.arraycopy(this.pointerLru, 0, this.pointerLru, 1, this.pointerLru.length - 1);
            this.pointerLru[0] = tmp;
        }
        return tmp;
    }
}

