/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.global;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class MemoryInputStream
extends InputStream {
    private InputStream parent;
    private byte[] memorizedBytes;
    private int offset;
    private int length;
    private int markedPos;

    public MemoryInputStream(InputStream inputstream) {
        this.parent = inputstream;
    }

    public int available() throws IOException {
        this.loadToMemory();
        return this.length - this.offset;
    }

    private void loadToMemory() throws IOException {
        if (this.parent == null) {
            throw new IOException("File does not existis");
        }
        if (this.memorizedBytes == null) {
            this.memorizedBytes = new byte[this.parent.available()];
            this.length = this.parent.read(this.memorizedBytes, 0, this.memorizedBytes.length);
        }
    }

    public int read() throws IOException {
        this.loadToMemory();
        if (this.offset >= this.length) {
            try {
                this.offset = 0;
                this.length = 0;
                this.length = this.parent.read(this.memorizedBytes, 0, this.memorizedBytes.length);
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
        return this.offset < this.length ? this.memorizedBytes[this.offset++] & 0xFF : -1;
    }

    public int read(byte[] abyte) throws IOException {
        return this.read(abyte, 0, abyte.length);
    }

    public int read(byte[] abyte, int abyteOffset, int abyteLength) throws IOException {
        this.loadToMemory();
        if (this.offset < this.length) {
            int len = Math.min(this.length - this.offset, abyteLength);
            System.arraycopy(this.memorizedBytes, this.offset, abyte, abyteOffset, len);
            this.offset += len;
            return len;
        }
        return this.parent.read(abyte, abyteOffset, abyteLength);
    }

    public void close() throws IOException {
        this.parent.close();
    }

    public long skip(long l) throws IOException {
        this.loadToMemory();
        if (this.offset < this.length) {
            int i = Math.min(this.length - this.offset, (int)l);
            this.offset += i;
            return i;
        }
        return this.parent.skip(l);
    }

    public synchronized void mark(int offset) {
        this.markedPos = offset;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void reset() throws IOException {
        this.offset = this.markedPos;
    }
}

